% MATLAB code: Example 11.2
% File: GCI.m
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
warning off;

nob   = 7000;  % sample size
nboot = 100;   % no of bootstrap replicates
nsim  = 500;   % number of simulations

a111 = 0.8;    % 1st regime, (1,1)
a112 = 0.5;    % matrix \Phi_{1}^{(1)}
a121 = 0;
a122 = 0;  

a211 = 0.5;   % 2nd regime
a212 = 0.3;   % matrix \Phi_{1}^{(2)}
a221 = 0;
a222 = 0;  

n112 = 0;
n121 = 0;
n212 = 0;
n221 = 0;

for jj=1:nsim   % BIG LOOP OVER LOOP FOR BOOTSTRAP
  disp(jj);
% randn('seed',0);
  r    = normrnd(0,1,nob,1);
  ran  = r;

  count1   = 0;
  count2   = 0;
  dat(1,1) = 0;
  dat(1,2) = 0;
  d(1,1)   = 0;
  d(1,2)   = 0;

%%  ALL Regimes
for i=2:nob
    if dat(i-1,2)<0;      
    count1         = count1+1;  % regime 1
    index1(count1) = i;
	    
    dat(i,1) = a111*dat(i-1,1)+a112*dat(i-1,2)+r(i);
    dat(i,2) = a122*dat(i-1,2)+r(i);
               
    d(i,1) = a111*d(i-1,1)+r(i);  % remove 2
    d(i,2) = a122*d(i-1,2)+r(i);  % remove 1
    else
    count2         = count2+1;  % regime 2  
    index2(count2) = i;
          
    dat(i,1) = a211*dat(i-1,1)+a212*dat(i-1,2)+r(i);
    dat(i,2) = a222*dat(i-1,2)+r(i);
         
    d(i,1) = a211*d(i-1,1)+r(i);  % remove 2 
    d(i,2) = a222*d(i-1,2)+r(i);  % remove 1
           
    end     % 2
end  % end do loop i=2,nob

for i=1:count1
  ser1(i,1) = dat(index1(i),1);  % 1st regime, 1st series
  ser1(i,2) = dat(index1(i),2);  %             2nd
  res1(i)   = ran(index1(i));
  y1(i,1)   = d(index1(i),1); % remove 2 
  y1(i,2)   = d(index1(i),2); % remove 1  
end

for i=1:count2
  ser2(i,1) = dat(index2(i),1);  % 2nd regime, 1st series
  ser2(i,2) = dat(index2(i),2);
  res2(i)   = ran(index2(i)); 
  y2(i,1)   = d(index2(i),1);  % remove 2 
  y2(i,2)   = d(index2(i),2);  % remove 1
end

X  = ser1(101:end,1);
Xd = X; % -mean(X);   no constant
n  = length(X);

% bb11= Xd(1:n-1)\X(2:end);
% B = [ones(length(X),1) X] \ Y    % with constant

[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigma11                  = stats(1,4);

X  = ser1(101:end,2);
Xd = X-mean(X);
n  = length(X);
% bb12 = Xd(1:n-1)\X(2:end);
[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigma12                  = stats(1,4);

X  = ser2(101:end,1);
Xd = X; % -mean(X);   no constant
n  = length(X);
% bb11 = Xd(1:n-1)\X(2:end);
% B = [ones(length(X),1) X] \ Y    % with constant
[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigma21                  = stats(1,4);

X  = ser2(101:end,2);
Xd = X-mean(X);
n  = length(X);
% bb12 = Xd(1:n-1)\X(2:end);
[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigma22                  = stats(1,4);  % 2nd regime, 2nd var

X  = y1(101:end,1);   %  1st regime, remove 2 
Xd = X; % -mean(X);   no constant
n  = length(X);
[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigmay12                 = stats(1,4);

X  = y1(101:end,2);   % 1st regime, remove 1  
Xd = X; % -mean(X);   no constant
n  = length(X);
[bhat,bint,r,rint,stats] =  regress(Xd(2:end),Xd(1:n-1));
sigmay11=stats(1,4);

X  = y2(101:end,1);   % 2nd regime, remove 2 
Xd = X; % -mean(X);   no constant
n  = length(X);
[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigmay22                 = stats(1,4);

X  = y2(101:end,2);   % 2nd regime, remove 1  
Xd = X; % -mean(X);   no constant
n  = length(X);
[bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
sigmay21                 = stats(1,4);

% remove 1->2
gci121 = log(sigmay11/sigma12);  % 1st regime, remove 1
gci221 = log(sigmay21/sigma22);  % 2nd regime, remove 1

% remove 2->1
gci112 = log(sigmay12/sigmay11); % 1st regime, remove 2 
gci212 = log(sigmay22/sigmay21); % 2nd regime, remove 2

for b=1:nboot  % BOOTSTRAPPING
    index1 = randsample(count1,count1);
    index2 = randsample(count2,count2);
    for i=1:count1
      rr1(i) = res1(index1(i)); 
    end
    for i=1:count2
      rr2(i) = res2(index2(i)); 
    end
    
    dat11(1) = 0;
    dat21(1) = 0;       
    dat22(1) = 0;
    dat12(1) = 0;
    db11(1)  = 0;
    db12(1)  = 0;
    db21(1)  = 0;
    db22(1)  = 0;
    
    for i=2:count1
      dat11(i) = a111*dat11(i-1)+a112*dat12(i-1)+rr1(i);
      dat12(i) = a122*dat12(i-1)+rr1(i);
          
      db11(i) = a111*db11(i-1)+rr1(i);  % remove 2 
      db12(i) = a122*db12(i-1)+rr1(i);  % remove 1

      x11(i-1,1) = dat11(i);
      x12(i-1,1) = dat12(i);
        
      yb11(i-1,1) = db11(i);
      yb12(i-1,1) = db12(i);        
    end
    
    for i=2:count2       
      dat21(i) = a211*dat21(i-1)+a212*dat22(i-1)+rr2(i);
      dat22(i) = a222*dat22(i-1)+rr2(i);

      db21(i) = a211*db21(i-1)+rr2(i);  % remove 2 
      db22(i) = a222*db22(i-1)+rr2(i);  % remove 1
       
      x21(i-1,1) = dat21(i);
      x22(i-1,1) = dat22(i); 
        
      yb21(i-1,1) = db21(i);
      yb22(i-1,1) = db22(i);        
    end
    
    X  = x11(101:end,1);
    Xd = X; % -mean(X);   no constant
    n  = length(X);
    % bb11 = Xd(1:n-1)\X(2:end);
    % B = [ones(length(X),1) X] \ Y    % with constant
    [b11,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmb11                 = stats(1,4);

    X  = x12(101:end,1);
    Xd = X-mean(X);
    n  = length(X);
    % bb12 = Xd(1:n-1)\X(2:end);
    [b12,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmb12                 = stats(1,4);

    X  = x21(101:end,1);
    Xd = X; % -mean(X);   no constant
    n  = length(X);
    % bb11 = Xd(1:n-1)\X(2:end);
    % B = [ones(length(X),1) X] \ Y    % with constant
    [b21,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmb21                 = stats(1,4);

    X  = x22(101:end,1);
    Xd = X-mean(X);
    n  = length(X);
    % bb12 = Xd(1:n-1)\X(2:end);
    [b22,bint,r,rint,stats] =  regress(Xd(2:end),Xd(1:n-1));
    sigmb22                 = stats(1,4);

    X  = yb12(101:end,1);   %  1st regime, remove 2
    Xd = X; % -mean(X);   no constant
    n  = length(X);
    [bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmayb12                = stats(1,4);

    X  = yb11(101:end,1);   % 1st regime, remove 1 
    Xd = X; % -mean(X);   no constant
    n  = length(X);
    [bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmayb11                = stats(1,4);

    X  = yb22(101:end,1);   % 2nd regime, remove 2 
    Xd = X; % -mean(X);   no constant
    n  = length(X);
    [bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmayb22                = stats(1,4);

    X  = yb21(101:end,1);   % 2nd regime, remove 1 
    Xd = X; % -mean(X);   no constant
    n  = length(X);
    [bhat,bint,r,rint,stats] = regress(Xd(2:end),Xd(1:n-1));
    sigmayb21                = stats(1,4);

% GCI
   % remove 1->2
   gcib121 = log(sigmayb11/sigmb12);  % 1st regime, remove 1
   gcib221 = log(sigmayb21/sigmb22);  % 2nd regime, remove 1

   % remove 2->1
   gcib112 = log(sigmayb12/sigmb11); % 1st regime, remove 2
   gcib212 = log(sigmayb22/sigmb21); % 2nd regime, remove 2

end   % end BOOTSTRAPPING b=1:nboot

% remove 1->2
q121(jj) = quantile(gcib121,0.95);
q221(jj) = quantile(gcib221,0.95);

% remove 2->1
q112(jj) = quantile(gcib112,0.95);
q212(jj) = quantile(gcib212,0.95);

%remove 1->2
if gci121>=q121(jj); 
   n121 = n121+1;
end
if gci221>=q221(jj); 
   n221 = n221+1;
end
if gci112>=q112(jj); 
   n112 = n112+1;
end
if gci212>=q212(jj); 
   n212 = n212+1;
end

end  %% END LOOP OVER LOOP FOR BOOTSTRAP jj=1:nsim 

n121 = n121/nsim;
n221 = n221/nsim;
n112 = n112/nsim;
n212 = n212/nsim;

% Y_{1}^{(J)} does not Granger-cause Y_{2}^{(J)} 
Y1_notG_Y2_J1 = (1 - n121)*100;  % J=1

% Y_{1}^{(J)} does not Granger-cause Y_{2}^{(J)} 
Y1_notG_Y2_J2 = (1 - n221)*100;  % J=2

% Y_{2}^{(J)} does not Granger-cause Y_{1}^{(J)} 
Y2_notG_Y1_J1 = (1 - n112)*100;  % J=1

% Y_{2}^{(J)} does not Granger-cause Y_{1}^{(J)}
Y2_notG_Y1_J2 = (1 - n212)*100;  % J=2

